<?php

namespace App\Http\Controllers;

use App\Models\Hadiah;
use App\Models\Modul;
use App\Models\Produk;
use Illuminate\Http\Request;
use Surfsidemedia\Shoppingcart\Facades\Cart;

class HomeController extends Controller
{
    public function index()
    {
        $slid = Modul::where('kode', 'BNS')->where('status', 'Y')->get();
        $ban_atas = Modul::where('kode', 'BNA')->get();
        $ban_bawah = Modul::where('kode', 'BNB')->get();
        $item = Hadiah::pencarian()->latest('id', 'desc')->paginate(12);
        $produk = Produk::pencarian()->latest()->paginate(12);
        $data = [
            'title' => 'Ramizah Store | Home',
            'page' => 'Home',
            'menuActive' => 'home',
            'menuOpen' => 'home',
        ];
        return view('home.home', compact('data', 'slid', 'ban_atas', 'ban_bawah', 'produk', 'item'))->with('no', 1);
    }


    public function tentang()
    {
        $m = Modul::where('kode', 'PFTG')->first();
        $data = [
            'title' => 'Ramizah Store | Tentang Kami',
            'page' => 'Tentang Kami',
            'menuActive' => 'tentang',
            'menuOpen' => 'tentang',
        ];
        return view('home.tentang', compact('data', 'm'));
    }

    public function layanan()
    {
        $m = Modul::where('kode', 'PFLY')->first();
        $data = [
            'title' => 'Ramizah Store | Layanan Toko',
            'page' => 'Layanan Toko',
            'menuActive' => 'layanan',
            'menuOpen' => 'layanan',
        ];
        return view('home.tentang', compact('data', 'm'));
    }

    public function kontak()
    {
        $data = [
            'title' => 'Ramizah Store | Kontak Kami',
            'page' => 'Kontak Kami',
            'menuActive' => 'kontak',
            'menuOpen' => 'kontak',
        ];
        return view('home.kontak', compact('data'));
    }

    public function detail($id)
    {
        $p = Produk::where('link_produk', $id)->first();
        $data = [
            'title' => 'Ramizah Store | Detail Produk',
            'page' => 'Detail Produk',
            'menuActive' => 'detail',
            'menuOpen' => 'detail',
        ];
        return view('home.detail', compact('data', 'p'));
    }

    public function keranjang()
    {
        $data = [
            'title' => 'Ramizah Store | Kontak Kami',
            'page' => 'Kontak Kami',
            'menuActive' => 'kontak',
            'menuOpen' => 'kontak',
        ];
        return view('home.keranjang', compact('data'));
    }

    public function produk()
    {
        $produk = Produk::pencarian()->latest()->paginate(12);
        $data = [
            'title' => 'Ramizah Store | Data Produk',
            'page' => ' Data Produk',
            'menuActive' => 'produk',
            'menuOpen' => 'produk',
        ];
        return view('home.produk', compact('data', 'produk'));
    }

    public function item()
    {
        $item = Hadiah::pencarian()->latest('id', 'desc')->paginate(12);
        $data = [
            'title' => 'Ramizah Store | Data Item Hadiah',
            'page' => ' Data Item Hadiah',
            'menuActive' => 'hadiah',
            'menuOpen' => 'hadiah',
        ];
        return view('home.item', compact('data', 'item'));
    }

    public function detail_item($id)
    {
        $p = Hadiah::where('link_hadiah', $id)->first();
        $data = [
            'title' => 'Ramizah Store | Detail Item Hadiah',
            'page' => 'Detail Item Hadiah',
            'menuActive' => 'hadiah',
            'menuOpen' => 'hadiah',
        ];
        return view('home.detail_hadiah', compact('data', 'p'));
    }
}
